/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class FspIoDrawerConfigId {
    private UnsignedInt16 mVersion = null;
    private UnsignedInt16 mEntryCount = null;
    private UnsignedInt16[] mConfigIds;
    private UnsignedInt16[] mRackAddresses;
    private UnsignedInt16[] mRackUnits;
    private String[] mTypes;
    private String[] mModels;
    private UnsignedInt8[] mUnitStatus;
    private String[] mPlantId;
    private String[] mSerialNumber;
    private String[] mLocationCode;
    private static final String IO_CONFIG_ID = "IO_CONFIG_ID";
    private static final String RACK_ADD = "RACK_ADD";
    private static final String UNIT_ADD = "UNIT_ADD";
    private static final String VERSION = "VERSION";
    private static final String TYPE = "TYPE";
    private static final String MODEL = "MODEL";
    private static final String UNIT_STATUS = "UNIT_STATUS";
    private static final String PLANT_ID = "PLANT_ID";
    private static final String SERIAL_NUM = "SERIAL_NUM";
    private static final String LOC_CODE = "LOC_CODE";
    private static final String GET_IO_DRAWER_CONFIG_ID = "GET_IO_DRAWER_CONFIG_ID";
    private static final String NUM_ENTRIES = "NUM_ENTRIES";
    private static final String DRAWER_ENTRY_LIST = "DRAWER_ENTRY_LIST";

    public FspIoDrawerConfigId() {
    }

    public FspIoDrawerConfigId(UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, Object[] objectArray) {
        this.mVersion = unsignedInt16;
        this.mEntryCount = unsignedInt162;
        int n = unsignedInt162.intValue();
        this.mConfigIds = new UnsignedInt16[n];
        this.mRackAddresses = new UnsignedInt16[n];
        this.mRackUnits = new UnsignedInt16[n];
        this.mTypes = new String[n];
        this.mModels = new String[n];
        this.mUnitStatus = new UnsignedInt8[n];
        this.mPlantId = new String[n];
        this.mSerialNumber = new String[n];
        this.mLocationCode = new String[n];
        for (int i = 0; i < n; ++i) {
            Hashtable hashtable = (Hashtable)objectArray[i];
            this.mConfigIds[i] = (UnsignedInt16)hashtable.get(IO_CONFIG_ID);
            this.mRackAddresses[i] = (UnsignedInt16)hashtable.get(RACK_ADD);
            this.mRackUnits[i] = (UnsignedInt16)hashtable.get(UNIT_ADD);
            this.mTypes[i] = (String)hashtable.get(TYPE);
            this.mModels[i] = (String)hashtable.get(MODEL);
            this.mUnitStatus[i] = (UnsignedInt8)hashtable.get(UNIT_STATUS);
            this.mPlantId[i] = (String)hashtable.get(PLANT_ID);
            this.mSerialNumber[i] = ((String)hashtable.get(SERIAL_NUM)).trim();
            this.mLocationCode[i] = ((String)hashtable.get(LOC_CODE)).trim();
        }
    }

    FspIoDrawerConfigId getIODrawerConfigIdCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        try {
            hashtable = fSPCmdMgr.doFSPCommand(GET_IO_DRAWER_CONFIG_ID, null);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            n = pIHscCmdMgrException.getStatus();
            HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
            if (n == 25) {
                throw new PIHscServerException("3421", pIHscCmdMgrException);
            }
            if (n == 28) {
                throw new PIHscServerException("3422", pIHscCmdMgrException);
            }
            throw new PIHscServerException("3424", new String[]{Integer.toHexString(n)}, pIHscCmdMgrException);
        }
        FspIoDrawerConfigId fspIoDrawerConfigId = new FspIoDrawerConfigId((UnsignedInt16)hashtable.get(VERSION), (UnsignedInt16)hashtable.get(NUM_ENTRIES), (Object[])hashtable.get(DRAWER_ENTRY_LIST));
        return fspIoDrawerConfigId;
    }

    public UnsignedInt16 getVersion() {
        return this.mVersion;
    }

    public UnsignedInt16 getEntryCount() {
        return this.mEntryCount;
    }

    public UnsignedInt16[] getConfigIds() {
        return this.mConfigIds;
    }

    public UnsignedInt16[] getRackAddresses() {
        return this.mRackAddresses;
    }

    public UnsignedInt16[] getRackUnits() {
        return this.mRackUnits;
    }

    public String[] getTypes() {
        return this.mTypes;
    }

    public String[] getModels() {
        return this.mModels;
    }

    public UnsignedInt8[] getUnitStatus() {
        return this.mUnitStatus;
    }

    public String[] getPlantId() {
        return this.mPlantId;
    }

    public String[] getSerialNumber() {
        return this.mSerialNumber;
    }

    public String[] getLocationCode() {
        return this.mLocationCode;
    }
}

